define(['angular', 'app', 'moment', 'PatientFHIRService'], function (angular, app, moment) {
    'use strict';

    app.service('ExtensionFHIRService', function ($q, BaseFHIRService, PatientFHIRService,CollectionCRUDService, formatter) {

        var getComponents = function(item) {
            if (typeof item.category === "object" && item.category.length > 0 && item.category[0].text) {
                item.category = [{text: item.category[0].text}];

                item.category[0].coding = [{
                    system: "http://hl7.org/fhir/goal-category",
                    code: "health",
                    display: "Health"
                }];
            }


            return item;
        };

        var resetStatus = function(item) {
            var statusList = [{"in-progress": "Active"},{"on-hold": "Inactive"},{"achieved": "Complete"}];
            var tStatusItem = statusList.filter(function(listItem) { return listItem[item.status]; });
            return (tStatusItem && tStatusItem.length > 0) ? tStatusItem[0][item.status] : item.status;
        };

        var resolveStatus = function(item) {
            var statusList = [{Active: "in-progress"},{Inactive: "on-hold"},{Complete: "achieved"}];
            var tStatusItem = statusList.filter(function(listItem) { return listItem[item.status]; });
            return (tStatusItem && tStatusItem.length > 0) ? tStatusItem[0][item.status] : item.status;
        };
        return angular.extend({}, angular.copy(BaseFHIRService), {
            type: 'Goal',


            dataPointers: {},


            requestTransform: function(item) {


                var currentDate = new Date();
                item.resourceType = "Goal";
                item.subject = {
                    reference: "Patient/" + this.patient.id
                };

                if (_.get(item, "extension[0].valueString")) {
                    item.extension[0].url = "http://pgdfhir.vamobile.us/fhir/StructureDefinition/goal-reward";
                    item.extension = [{
                        url: item.extension[0].url,
                        valueString: item.extension[0].valueString
                    }];
                } else {
                    delete item.extension;
                }

                item.identifier = [{
                    value: item.identifier[0].value
                }];
                item.outcome.resultReference = 'Observation/{{unique_ID}}';
                item.startDate = formatter.getFormattedBackendDate(item.startDate);
                item.targetDate = formatter.getFormattedBackendDate(item.endDate);
                item.status = resolveStatus(item);
                getComponents(item);

                delete item['endDate'];

                for (var i = 0; i < item.note.length; i++) {
                    var step = item.note[i];

                    // authorString === step complete checkbox in UI or progress bars
                    if (_.has(step, 'authorString')) {
                        if (step.authorString === "progress") {
                            step.text = parseInt(step.text);
                            item.progresses.push(step);
                        } else if (step.authorString) {
                            // must convert boolean to string for backend validation to pass
                            step.authorString = "true";
                        } else {
                            step.authorString = "false"
                        }
                    }

                    if (step.text) {
                        step.time = formatter.getFormattedBackendDateTime(step.time);
                    } else {
                        item.note.splice(i, 1);
                        i--;
                    }
                }

                if (item.progresses) {
                    item.progresses.forEach(function(progress) {
                        progress.time = formatter.getFormattedBackendDate(progress.time);
                        item.note.push(progress)
                    });
                    delete item.progresses;
                } else {
                    delete item.progresses;
                }

                if (item.note.length === 0) {
                    delete item.note;
                }

                if (item.createdDate) {
                    delete item.createdDate;
                }

                if (item.notificationStatus) {
                    delete item.notificationStatus;
                }

                if (!item.description) {
                    item.description = "<blank description value>";
                }

                if (item.statusDate) {
                    item.statusDate = formatter.getFormattedBackendDate(item.statusDate);
                } else {
                    item.statusDate = "";
                }

                return item;
            },
            queryParamsFhirTransform: function(queryParams) {
                var fhirParams = {};

                if (queryParams && queryParams.subject) {
                    fhirParams.subject = "Patient/" + this.patient.id;
                }
                if (queryParams.startDate && queryParams.endDate) {
                    fhirParams.targetdate = [">=" + formatter.getFormattedBackendDateTime(queryParams.startDate+" 00:00:00"),
                        "<=" + formatter.getFormattedBackendDateTime(queryParams.endDate+" 23:59:59")];
                }
                if (queryParams.status) {
                    fhirParams.status = resolveStatus(queryParams);
                }
                if (queryParams.type) {
                    fhirParams.category = queryParams.type.toLowerCase();
                }
                fhirParams['_count'] = 100;

                return fhirParams;
            },

            save: function (ngModel) {


               // ngModel.effectiveDateTime = this.buildEffectiveDateTime(ngModel);


                return PatientFHIRService.getPatientContext().then(function(patientContext){
                    if (patientContext) {

                        var requestType = ngModel.id ? 'update': 'create';
                        var resource = this.buildResource(ngModel);



                        return this[requestType](resource).then(function (response) {
                            // Workaround because the FHIR server doesn't allow querying immediately after creating a resource
                            setTimeout(function () {

                                this.fetch().then(function () {

                                    this.latest = this.dataPointers.list[0];

                                    return response;
                                }.bind(this));

                            }.bind(this), 1000);

                        }.bind(this));

                    }

                }.bind(this));


            },

            buildEffectiveDateTime: function (ngModel, item) {
                var combinedDateTimeFormat = 'MM/DD/YYYY hh:mm A';
                var combinedDateTime = new moment(item.meta.lastupdated, combinedDateTimeFormat);

                return combinedDateTime.format('YYYY-MM-DDTHH:mm:ssZ');
            },

            buildResource: function (ngModel, item) {
                angular.extend(ngModel, {
                    resourceType: this.type,
                 //   effectiveDateTime: this.buildEffectiveDateTime(ngModel,item),
                    inputEntryDate: undefined,
                    inputEntryTime: undefined
                });

                if (ngModel.comments === "") {
                    // empty comments are not allowed to be saved
                    delete ngModel.comments;
                }



                return ngModel;
            },

            create: function (resource) {
                return this.checkForSameDate(resource.effectiveDateTime).then(function () {

                    return BaseFHIRService.create.call(this, resource);
                }.bind(this));
            },

            checkForSameDate: function (date) {
                var errorsObj = {
                    'objectType': 'ValidationWarning',
                    errors: [
                        {
                            errorMessage: 'An entry has already been saved with the same date and time. Please change your date and/or time and save again.'}
                    ]
                };

                return $q(function (resolve, reject,ngModel) {
                    this.search({
                        //code: this.code,
                        // date: date
                        //subject: ngModel.subject.reference,
                        status: 'in-progress'
                    }).then(function (response) {
                        var count = response.getTotal();

                        if (count) {
                            //reject(errorsObj);
                            resolve();
                        } else {
                            resolve();
                        }
                    }, function (response) {
                        reject(response);
                    });
                }.bind(this));
            },

            delete: function (ngModel) {
                return BaseFHIRService.delete.call(this, ngModel.id).then(function (response) {
                    var urlSections = response.config.url.split('/');

                    this.removeFromLocalList(urlSections[urlSections.length - 1]);
                    this.latest = this.dataPointers.list[0];

                    return response;
                }.bind(this));
            },

            removeFromLocalList: function (id) {
                var item = this.localGetById(id);
                var index = this.dataPointers.list.indexOf(item);

                if (index !== -1) {
                    this.dataPointers.list.splice(index, 1);
                }
            },

            getLatest: function (filtersObj) {
                return PatientFHIRService.getPatientContext().then(function (patientContext,ngModel){
                    filtersObj = filtersObj || {};
                    if(patientContext) {

                        delete filtersObj.activeFlag;

                        return this.search({
                            _count: 1,
                            status: 'in-progress' ,
                            //'_sort:desc': 'date',
                            patient: patientContext.id
                        }).then(function (response) {
                            this.latest = response.getItems()[0];
                        }.bind(this));
                    }
                }.bind(this));
            },

            localGetById: function (id) {
                var list = this.dataPointers.list || [];

                var item = this.findInArray(list, function (item) {
                    return item.id === id;
                });

                if (item) {
                    this.transformItem(item);
                }

                return item;
            },

            transformItem: function (item) {

                angular.extend(item, {
                    inputEntryDate: this.getDateFromDateTime(item.effectiveDateTime),
                    inputEntryTime: this.getTimeFromDateTime(item.effectiveDateTime)
                });
            },

            createEmpty: function () {
                var today = moment();

                return {
                    status: 'preliminary',
                    inputEntryDate: this.getDateFromDateTime(today),
                    inputEntryTime: this.getTimeFromDateTime(today),
                    comments: '',
                    subject: {},
                    extension: [],
                    outcome : []
                };
            },

            getDateFromDateTime: function (dateTime, format) {
                format = format || 'MM/DD/YYYY'

                return moment(new Date(dateTime)).format(format);
            },

            getTimeFromDateTime: function (dateTime) {
                return moment(new Date(dateTime)).format('hh:mm A');
            },

            fetch: function (filtersObj) {
                filtersObj = filtersObj || {};
                return PatientFHIRService.getPatientContext().then(function(patientContext){
                    if(patientContext,filtersObj) {
                        var filters = angular.copy(filtersObj);

                        delete filters.startDate;
                        delete filters.endDate;
                        delete filters.activeFlag;


                        angular.extend(filters, {
                            //code: this.code,
                            status : 'in-progress' ,
                            //'_sort:desc': 'date',
                            patient: patientContext.id,
                           // startDate: filtersObj.startDate ? this.getDateFromDateTime(filtersObj.startDate, dateFormat) : moment().subtract(1, 'y').format(dateFormat),
                           // targetDate: filtersObj.targetDate ? this.getDateFromDateTime(filtersObj.targetDate, dateFormat) : moment().format(dateFormat)
                        });

                        return this.search(filters).then(function (response) {
                            return response.getAllItems().then(function (response) {
                                this.dataPointers.list = response;
                                return;
                            }.bind(this));
                        }.bind(this));
                    }
                }.bind(this));
            }
        });
    });




});

